module Refs
	( Ref(Ref)
	, idref
	, (.*.)
	, declare2
	, declare3
	, declare4
	, declare5
	, declareL
	, convert
	, convertL
	) where

import List
import Maybe

data Ref cx t = Ref (cx->t) ((t->t)->(cx->cx))

idref :: Ref a a
idref = Ref id id

infixr 5 .*.
(.*.) ::
	((a -> (b->e)) -> Ref cx t1 -> (b->e)) ->
	((b -> e) -> Ref cx t2 -> e) ->
	((a,b) -> e) -> Ref cx (t1,t2) -> e
(f1 .*. f2) refs_to_form ref =
	f2 (f1 (curry refs_to_form) ref1) ref2
	where
	(ref1,ref2) = splitref2 ref

declare2 ::  ((Ref cx t1, Ref cx t2) -> e) -> (Ref cx (t1,t2) -> e)
declare2 to_form = to_form . splitref2
-- NOTE: could also be defined as: declare2 = id.*.id

declare3 ::  ((Ref cx t1, Ref cx t2, Ref cx t3) -> e) -> (Ref cx (t1,t2,t3) -> e)
declare3 to_form = to_form . splitref3

declare4 :: ((Ref cx t1, Ref cx t2, Ref cx t3, Ref cx t4) -> e) -> (Ref cx (t1,t2,t3,t4) -> e) 
declare4 to_form = to_form . splitref4

declare5 ::  ((Ref cx t1, Ref cx t2, Ref cx t3, Ref cx t4, Ref cx t5) -> e) -> (Ref cx (t1,t2,t3,t4,t5) -> e)
declare5 to_form = to_form . splitref5


splitref2 :: Ref cx (t1,t2) -> (Ref cx t1, Ref cx t2)
splitref2 (Ref val app) = (ref1, ref2)
	where
	ref1 = Ref (fst . val) (app . appfst)
	ref2 = Ref (snd . val) (app . appsnd)
	appfst f ~(x,y) = (f x, y)
	appsnd f ~(x,y) = (x, f y)

splitref3 :: Ref cx (t1,t2,t3) -> (Ref cx t1, Ref cx t2, Ref cx t3)
splitref3 (Ref v a) = (Ref v1 a1, Ref v2 a2, Ref v3 a3)
	where
	v1 = fst3 . v
	v2 = snd3 . v
	v3 = thd3 . v
	a1 = a . appfst3
	a2 = a . appsnd3
	a3 = a . appthd3
	fst3 (x1,x2,x3) = x1
	snd3 (x1,x2,x3) = x2
	thd3 (x1,x2,x3) = x3
	appfst3 f ~(x1,x2,x3) = (f x1, x2, x3)
	appsnd3 f ~(x1,x2,x3) = (x1, f x2, x3)
	appthd3 f ~(x1,x2,x3) = (x1, x2, f x3)

splitref4 :: Ref cx (t1,t2,t3,t4) -> (Ref cx t1, Ref cx t2, Ref cx t3, Ref cx t4)
splitref4 (Ref v a) = (Ref v1 a1, Ref v2 a2, Ref v3 a3, Ref v4 a4)
	where
	v1 = fst4 . v
	v2 = snd4 . v
	v3 = thd4 . v
	v4 = for4 . v
	a1 = a . appfst4
	a2 = a . appsnd4
	a3 = a . appthd4
	a4 = a . appfor4
	fst4 (x1,x2,x3,x4) = x1
	snd4 (x1,x2,x3,x4) = x2
	thd4 (x1,x2,x3,x4) = x3
	for4 (x1,x2,x3,x4) = x4
	appfst4 f ~(x1,x2,x3,x4) = (f x1, x2, x3, x4)
	appsnd4 f ~(x1,x2,x3,x4) = (x1, f x2, x3, x4)
	appthd4 f ~(x1,x2,x3,x4) = (x1, x2, f x3, x4)
	appfor4 f ~(x1,x2,x3,x4) = (x1, x2, x3, f x4)

splitref5 :: Ref cx (t1,t2,t3,t4,t5) -> (Ref cx t1, Ref cx t2, Ref cx t3, Ref cx t4, Ref cx t5)
splitref5 (Ref v a) = (Ref v1 a1, Ref v2 a2, Ref v3 a3, Ref v4 a4, Ref v5 a5)
	where
	v1 = fst5 . v
	v2 = snd5 . v
	v3 = thd5 . v
	v4 = for5 . v
	v5 = fif5 . v
	a1 = a . appfst5
	a2 = a . appsnd5
	a3 = a . appthd5
	a4 = a . appfor5
	a5 = a . appfif5
	fst5 (x1,x2,x3,x4,x5) = x1
	snd5 (x1,x2,x3,x4,x5) = x2
	thd5 (x1,x2,x3,x4,x5) = x3
	for5 (x1,x2,x3,x4,x5) = x4
	fif5 (x1,x2,x3,x4,x5) = x5
	appfst5 f ~(x1,x2,x3,x4,x5) = (f x1, x2, x3, x4, x5)
	appsnd5 f ~(x1,x2,x3,x4,x5) = (x1, f x2, x3, x4, x5)
	appthd5 f ~(x1,x2,x3,x4,x5) = (x1, x2, f x3, x4, x5)
	appfor5 f ~(x1,x2,x3,x4,x5) = (x1, x2, x3, f x4, x5)
	appfif5 f ~(x1,x2,x3,x4,x5) = (x1, x2, x3, x4, f x5)


declareL :: ([Ref cx t] -> e) -> (Ref cx [t] -> e)
declareL f = f . splitrefL

splitrefL :: Ref cx [t] -> [Ref cx t]
splitrefL (Ref val app) = refhead:(splitrefL reftail)
	where
	refhead = Ref (head . val) (app . apphead)
	reftail = Ref (tail . val) (app . apptail)
	apphead f ~(x:xs) = (f x):xs
	apptail f ~(x:xs) = x:(f xs)

	
{-
splitref2gen f1 f2 ref = (f1 ref1, f2 ref2)
	where (ref1,ref2) = splitref2 ref

splitrefLgen f ref = map f (splitrefL ref)

declaregen splitfun to_form = to_form . splitfun
-}


type Bijection a b = (a->b, b->a)

convert :: Bijection a b -> (Ref cx b -> thing) -> (Ref cx a -> thing)
convert bij f = f . convertref bij
	where
	convertref :: Bijection a b -> Ref cx a -> Ref cx b
	convertref (forth,back) (Ref val app) =
		Ref (forth . val) (\f-> app $ back . f . forth)


convertL :: Eq a => [a] -> (Ref cx Int -> thing) -> (Ref cx a -> thing)
convertL items = convert (forth,back)
	where
	forth a = fromJust $ elemIndex a items
	back i = items!!i

