{-
This module structures the FForm type as a monad, where the monadic value
corresponds to the layout information --- usually of type Layout, but also
sometimes [Layout] or TabPage. This is particularly useful for lifting
wxHaskell's layout combinators into the editor domain, which can be done
with the monad functions return, liftM, mapM, sequence (see module
FFormsLayout).
-}

module FFormsMonad(FForm(FForm)) where

import Graphics.UI.WX(Window)
import Monad

newtype FForm cx w a = FForm (Window w -> cx -> IO (a, IO (cx->cx)))

instance Monad (FForm cx w)
	where
	return x = FForm $ \w cx ->
		return (x, return id)
	(FForm form1) >>= f = FForm $ \w cx ->
		do	(x,getupd1) <- form1 w cx
			let (FForm form2) = f x
			(y,getupd2) <- form2 w cx
			return (y, liftM2 (.) getupd1 getupd2)
