module FFormsLayout
	( panel'
	, label', rule', hrule', vrule'
	, row', column'
	, grid', boxed', tab', imageTab', tabs'
	, glue', hglue', vglue'
	, space', hspace', vspace', empty'
	, dynamic'
	, static', stretch', hstretch', vstretch', minsize'
	, rigid', shaped', expand'
	, fill', hfill', vfill'
	, margin', marginWidth', marginNone'
	, marginLeft', marginTop', marginRight', marginBottom'
	, floatTopLeft', floatTop', floatTopRight'
	, floatLeft', floatCentre', floatCenter', floatRight'
	, floatBottomLeft', floatBottom', floatBottomRight'
	, hfloatLeft', hfloatCentre', hfloatCenter', hfloatRight'
	, vfloatTop', vfloatCentre', vfloatCenter', vfloatBottom'
	, centre'
	, alignTopLeft', alignTop', alignTopRight'
	, alignLeft', alignCentre', alignCenter', alignRight'
	, alignBottomLeft', alignBottom', alignBottomRight'
	, halignLeft', halignCentre', halignCenter', halignRight'
	, valignTop', valignCentre', valignCenter', valignBottom'
	) where

import Graphics.UI.WX
import Graphics.UI.WXCore
import Monad
import FFormsMonad


-- ######## containers as layout combinators #############

panel' :: [Prop (Panel ())] -> FForm cx (CPanel ()) Layout -> FForm cx w Layout
panel' props (FForm fm) = FForm $ \w cx ->
	do	p <- panel w props
		(lay,upd) <- fm p cx
		return (container p lay, upd)



-- ####### lifted wxHaskell layout combinators ##############
label' :: String -> FForm cx w Layout
label' title = return (label title)

rule' :: Int -> Int -> FForm cx w Layout
rule' w h = return (rule w h)

hrule' :: Int -> FForm cx w Layout
hrule' w = return (hrule w)

vrule' :: Int -> FForm cx w Layout
vrule' h = return (vrule h)

row' :: Int -> [FForm cx w Layout] -> FForm cx w Layout
row' gap forms = liftM (row gap) $ sequence forms

column' :: Int -> [FForm cx w Layout] -> FForm cx w Layout
column' gap forms = liftM (column gap) $ sequence forms

grid' :: Int -> Int -> [[FForm cx w Layout]] -> FForm cx w Layout
grid' hgap vgap formss = liftM (grid hgap vgap) $ mapM sequence formss

boxed' :: String -> FForm cx w Layout -> FForm cx w Layout
boxed' title = liftM (boxed title)

-- NOTE: tab' puts a panel around its editor argument
-- tab' :: String -> FForm cx (CPanel ()) Layout -> FForm cx w Graphics.UI.WX.TabPage
-- cannot give type declaration because TabPage type is not exported (wxHaskell bug)
tab' title form = liftM (tab title) $ panel' [] form

-- NOTE: imageTab' puts a panel around its editor argument
-- imageTab' :: String -> Bitmap () -> FForm cx (CPanel ()) Layout -> FForm cx w Graphics.UI.WX.TabPage
imageTab' title icon form = liftM (imageTab title icon) $ panel' [] form

-- NOTE: tabs' also creates the required notebook control
-- tabs' :: [FForm cx (CControl (CNotebook ())) TabPage] -> FForm cx w Layout
tabs' tpForms = FForm $ \w cx ->
	do	nb <- notebook w []
		let (FForm fm) = sequence tpForms
		(tabpages,upd) <- fm nb cx
		return (tabs nb tabpages, upd)
		
{- can't use a splitter window inside an OK/Cancel dialog
hsplit' ::
	[Prop (SplitterWindow ())] ->
	Int -> Int ->
	FForm cx (CSplitterWindow ()) Layout ->
	FForm cx (CSplitterWindow ()) Layout ->
	FForm cx w Layout
hsplit' props sash left (FForm fm1) (FForm fm2) = FForm $ \w cx ->
	do	s <- splitterWindow w props
		(lay1,upd1) <- fm1 s cx
		(lay2,upd2) <- fm2 s cx
		return (hsplit s sash left lay1 lay2, liftM2 (.) upd1 upd2)
-}

glue' :: FForm cx w Layout
glue' = return glue

hglue' :: FForm cx w Layout
hglue' = return hglue

vglue' :: FForm cx w Layout
vglue' = return vglue

space' :: Int -> Int -> FForm cx w Layout
space' w h = return $ space w h

hspace' :: Int -> FForm cx w Layout
hspace' w = return (hspace w)

vspace' :: Int -> FForm cx w Layout
vspace' h = return (vspace h)

empty' :: FForm cx w Layout
empty' = return empty

dynamic' :: FForm cx w Layout -> FForm cx w Layout
dynamic' = liftM dynamic

static' :: FForm cx w Layout -> FForm cx w Layout
static' = liftM static

stretch' :: FForm cx w Layout -> FForm cx w Layout
stretch' = liftM stretch

hstretch' :: FForm cx w Layout -> FForm cx w Layout
hstretch' = liftM hstretch

vstretch' :: FForm cx w Layout -> FForm cx w Layout
vstretch' = liftM vstretch

minsize' :: Size -> FForm cx w Layout -> FForm cx w Layout
minsize' size = liftM (minsize size)

rigid' :: FForm cx w Layout -> FForm cx w Layout
rigid' = liftM rigid

shaped' :: FForm cx w Layout -> FForm cx w Layout
shaped' = liftM shaped

expand' :: FForm cx w Layout -> FForm cx w Layout
expand' = liftM expand

fill' :: FForm cx w Layout -> FForm cx w Layout
fill' = liftM fill

hfill' :: FForm cx w Layout -> FForm cx w Layout
hfill' = liftM hfill

vfill' :: FForm cx w Layout -> FForm cx w Layout
vfill' = liftM vfill

margin' :: Int -> FForm cx w Layout -> FForm cx w Layout
margin' width = liftM (margin width)

marginWidth' :: Int -> FForm cx w Layout -> FForm cx w Layout
marginWidth' width = liftM (marginWidth width)

marginNone' :: FForm cx w Layout -> FForm cx w Layout
marginNone' = liftM marginNone

marginLeft' :: FForm cx w Layout -> FForm cx w Layout
marginLeft' = liftM marginLeft

marginTop' :: FForm cx w Layout -> FForm cx w Layout
marginTop' = liftM marginTop

marginRight' :: FForm cx w Layout -> FForm cx w Layout
marginRight' = liftM marginRight

marginBottom' :: FForm cx w Layout -> FForm cx w Layout
marginBottom' = liftM marginBottom

floatTopLeft' :: FForm cx w Layout -> FForm cx w Layout
floatTopLeft' = liftM floatTopLeft

floatTop' :: FForm cx w Layout -> FForm cx w Layout
floatTop' = liftM floatTop

floatTopRight' :: FForm cx w Layout -> FForm cx w Layout
floatTopRight' = liftM floatTopRight

floatLeft' :: FForm cx w Layout -> FForm cx w Layout
floatLeft' = liftM floatLeft

floatCentre' :: FForm cx w Layout -> FForm cx w Layout
floatCentre' = liftM floatCentre

floatCenter' :: FForm cx w Layout -> FForm cx w Layout
floatCenter' = liftM floatCenter

floatRight' :: FForm cx w Layout -> FForm cx w Layout
floatRight' = liftM floatRight

floatBottomLeft' :: FForm cx w Layout -> FForm cx w Layout
floatBottomLeft' = liftM floatBottomLeft

floatBottom' :: FForm cx w Layout -> FForm cx w Layout
floatBottom' = liftM floatBottom

floatBottomRight' :: FForm cx w Layout -> FForm cx w Layout
floatBottomRight' = liftM floatBottomRight

hfloatLeft' :: FForm cx w Layout -> FForm cx w Layout
hfloatLeft' = liftM hfloatLeft

hfloatCentre' :: FForm cx w Layout -> FForm cx w Layout
hfloatCentre' = liftM hfloatCentre

hfloatCenter' :: FForm cx w Layout -> FForm cx w Layout
hfloatCenter' = liftM hfloatCenter

hfloatRight' :: FForm cx w Layout -> FForm cx w Layout
hfloatRight' = liftM hfloatRight

vfloatTop' :: FForm cx w Layout -> FForm cx w Layout
vfloatTop' = liftM vfloatTop

vfloatCentre' :: FForm cx w Layout -> FForm cx w Layout
vfloatCentre' = liftM vfloatCentre

vfloatCenter' :: FForm cx w Layout -> FForm cx w Layout
vfloatCenter' = liftM vfloatCenter

vfloatBottom' :: FForm cx w Layout -> FForm cx w Layout
vfloatBottom' = liftM vfloatBottom

centre' :: FForm cx w Layout -> FForm cx w Layout
centre' = liftM centre

alignTopLeft' :: FForm cx w Layout -> FForm cx w Layout
alignTopLeft' = liftM alignTopLeft

alignTop' :: FForm cx w Layout -> FForm cx w Layout
alignTop' = liftM alignTop

alignTopRight' :: FForm cx w Layout -> FForm cx w Layout
alignTopRight' = liftM alignTopRight

alignLeft' :: FForm cx w Layout -> FForm cx w Layout
alignLeft' = liftM alignLeft

alignCentre' :: FForm cx w Layout -> FForm cx w Layout
alignCentre' = liftM alignCentre

alignCenter' :: FForm cx w Layout -> FForm cx w Layout
alignCenter' = liftM alignCenter

alignRight' :: FForm cx w Layout -> FForm cx w Layout
alignRight' = liftM alignRight

alignBottomLeft' :: FForm cx w Layout -> FForm cx w Layout
alignBottomLeft' = liftM alignBottomLeft

alignBottom' :: FForm cx w Layout -> FForm cx w Layout
alignBottom' = liftM alignBottom

alignBottomRight' :: FForm cx w Layout -> FForm cx w Layout
alignBottomRight' = liftM alignBottomRight

halignLeft' :: FForm cx w Layout -> FForm cx w Layout
halignLeft' = liftM halignLeft

halignCentre' :: FForm cx w Layout -> FForm cx w Layout
halignCentre' = liftM halignCentre

halignCenter' :: FForm cx w Layout -> FForm cx w Layout
halignCenter' = liftM halignCenter

halignRight' :: FForm cx w Layout -> FForm cx w Layout
halignRight' = liftM halignRight

valignTop' :: FForm cx w Layout -> FForm cx w Layout
valignTop' = liftM valignTop

valignCentre' :: FForm cx w Layout -> FForm cx w Layout
valignCentre' = liftM valignCentre

valignCenter' :: FForm cx w Layout -> FForm cx w Layout
valignCenter' = liftM valignCenter

valignBottom' :: FForm cx w Layout -> FForm cx w Layout
valignBottom' = liftM valignBottom


